/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package hr.algebra.dao.file;

import hr.algebra.dao.Repository;
import hr.algebra.model.Student;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;


public class FileRepository implements Repository {
    
    private static final String DIR = "files";
    private static final Path PATH_DIR = Paths.get(DIR);
    private static final Path PATH_STUDENTS = Paths.get(DIR + File.separator + "students.txt");

    public FileRepository() throws IOException {
        if (!Files.exists(PATH_STUDENTS)) {
            Files.createDirectories(PATH_DIR);
            Files.createFile(PATH_STUDENTS);
        }
    }
    
    

    @Override
    public int createStudent(Student student) throws Exception {

        int maxId = selectStudents()
                .stream() // students
                .mapToInt(s -> s.getId()) // ids
                .max()
                .orElse(0);
        
        
        student.setId(++maxId);
        Files.write(
                PATH_STUDENTS, 
                student.format().getBytes(), 
                StandardOpenOption.APPEND);
        
        return maxId;
    }

    @Override
    public void updateStudent(int id, Student data) throws Exception {
        List<Student> students = selectStudents();
        Optional<Student> opt = students.stream()
                .filter(s -> s.getId() == id)
                .findFirst();
        if (opt.isPresent()) {
            Student student = opt.get();
            student.update(data);
            writeStudents(students);
        }
    }

    @Override
    public void deleteStudent(int id) throws Exception {
        List<Student> students = selectStudents();
        students.removeIf(s -> s.getId() == id);
        writeStudents(students);
    }

    @Override
    public Student selectStudent(int id) throws Exception {

        return 
                selectStudents()
                .stream()
                .filter(s -> s.getId() == id)
                .findFirst()
                .orElse(null);
                
    }

    @Override
    public List<Student> selectStudents() throws Exception {
        return Files.readAllLines(PATH_STUDENTS)
                .stream() // lines
                .map(Student::parse)
                .collect(Collectors.toList());
    }

    private void writeStudents(List<Student> students) throws IOException {
        Files.write(
                PATH_STUDENTS,
                students
                .stream() // students
                .map(Student::format) // lines
                .collect(Collectors.joining())
                .getBytes()

        );
    }
    
}
