/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.dal;

import hr.algebra.dal.sql.DataSourceSingleton;
import hr.algebra.dal.sql.SqlRepository;
import java.io.InputStream;
import java.util.Properties;

/**
 *
 * @author dnlbe
 */
public class RepositoryFactory {

    private static Repository repository;
    
    private static final Properties PROPERTIES = new Properties();
    private static final String PATH = "/config/repository.properties";
    private static final String CLASS_NAME = "CLASS_NAME";
    
    static {
        try (InputStream is = RepositoryFactory.class.getResourceAsStream(PATH)){
            PROPERTIES.load(is);
            
            // CLASS_NAME = "hr.algebra.dal.sql.SqlRepository"
            repository = (Repository) Class.forName(PROPERTIES.getProperty(CLASS_NAME))
                    .getDeclaredConstructor()
                    .newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public static void main(String[] args) {
        System.out.println(repository.getClass());
    }

    private RepositoryFactory() {
    }
    // LAZY SINGLETON
    public static Repository getRepository() throws Exception {
        return repository;
    }
}
