package hr.algebra.serialization.model;

import java.io.Serial;
import java.io.Serializable;
import java.util.Objects;

public final class Index implements Serializable {
    @Serial
    private static final long serialVersionUID = -2L;

    private final int number;
    private final String issuer;

    public Index(int number, String issuer) {
        Objects.requireNonNull(issuer);
        this.number = number;
        this.issuer = issuer;
    }

    public String getIssuer() {
        return issuer;
    }

    @Override
    public String toString() {
        return "Index{" +
                "number=" + number +
                ", issuer='" + issuer + '\'' +
                '}';
    }
}
