package hr.algebra.parsers;

import hr.algebra.model.Employee;
import hr.algebra.model.EmployeeTag;
import hr.algebra.model.EmployeeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DOMParserDemo {
    // copy from StAX
    private static final String FILENAME = "/employees.xml";
    private static final String TYPE = "type";

    public static void main(String[] args) {
        try {
//            String path = Objects.requireNonNull(SAXParserDemo.class.getResource(FILENAME)).getFile();
            String path = URLDecoder.decode(
                    Objects.requireNonNull(SAXParserDemo.class.getResource(FILENAME)).getFile(),
                    StandardCharsets.UTF_8
            );
            List<Employee> employees = parse(path);
            System.out.println(employees);
        } catch (ParserConfigurationException | IOException | SAXException e) {
            e.printStackTrace();
        }
    }

    private static List<Employee> parse(String path) throws ParserConfigurationException, IOException, SAXException {
        List<Employee> employees = new ArrayList<>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        // if we break <incom>, without the error handler, it will notify us regarding that it should have an ErrorHandler
        builder.setErrorHandler(new ErrorHandler() {
            @Override
            public void warning(SAXParseException exception) throws SAXException {
                System.err.println("Warning: " + exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        Document document = builder.parse(new File(path));
        retrieveEmployees(document, employees);
        return employees;
    }

    private static void retrieveEmployees(Document document, List<Employee> employees) {
        Element documentElement = document.getDocumentElement();
        NodeList nodes = documentElement.getElementsByTagName(EmployeeTag.EMPLOYEE.toString());
        for (int i = 0; i < nodes.getLength(); i++) {
            Employee employee = new Employee();
            employees.add(employee);
            Element item = (Element) nodes.item(i);
            employee.setEmployeeType(Enum.valueOf(EmployeeType.class, item.getAttributeNode(TYPE).getValue()));
            employee.setId(Integer.parseInt(item.getElementsByTagName(EmployeeTag.ID.toString()).item(0).getTextContent()));
            employee.setFirstName(item.getElementsByTagName(EmployeeTag.FIRSTNAME.toString()).item(0).getTextContent());
            employee.setLastName(item.getElementsByTagName(EmployeeTag.LASTNAME.toString()).item(0).getTextContent());
            employee.setIncome(Double.parseDouble(item.getElementsByTagName(EmployeeTag.INCOME.toString()).item(0).getTextContent()));
        }
    }

}
