package hr.algebra.xsd;

import hr.algebra.parsers.SAXParserDemo;
import org.xml.sax.SAXException;

import javax.xml.XMLConstants;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

import static hr.algebra.utilities.XSDValidator.validate;

public class Validation {
    private static final String XML_FILENAME = "/employees_xsd.xml";
    private static final String XSD_FILENAME = "/employees.xsd";

    public static void main(String[] args) {
//        String xmlFilePath = Objects.requireNonNull(Validation.class.getResource(XML_FILENAME)).getFile();
        String xmlFilePath = URLDecoder.decode(
                Objects.requireNonNull(SAXParserDemo.class.getResource(XML_FILENAME)).getFile(),
                StandardCharsets.UTF_8
        );
//        String xsdFilePath = Objects.requireNonNull(Validation.class.getResource(XSD_FILENAME)).getFile();
        String xsdFilePath = URLDecoder.decode(
                Objects.requireNonNull(SAXParserDemo.class.getResource(XSD_FILENAME)).getFile(),
                StandardCharsets.UTF_8
        );

        try {
            // warning: exception driven programming
            validate(
                    xmlFilePath,
                    xsdFilePath,
                    XMLConstants.W3C_XML_SCHEMA_NS_URI);
        } catch (SAXException | IOException e) {
            e.printStackTrace();
        }
    }

}
