package hr.algebra.reflection.classloader;

public class Demo {
    public static void main(String[] args) {
        try {
            Class<?> object = Class.forName("java.lang.Object");
            System.out.println(object.toString());
            ClassLoader bcl = object.getClassLoader(); // null
            System.out.println("Classloader for object: " + bcl);

            Class<?> driver = java.sql.Driver.class;
            ClassLoader pcl = driver.getClassLoader(); // PlatformClassLoader
            System.out.println("Classloader for java.sql.Driver: " + pcl);

            //Class<?> dummy = Dummy.class;
            // there's subtle difference (if class is loaded in virtual machine, the static is called by default - more on this later)
            /*
            Class<?> dummy = Class.forName(
                    "hr.algebra.reflection.classloader.Dummy",
                    false, // true
                    new DummyClassLoader()); // static not called
             */
            Class<?> dummy = Class.forName("hr.algebra.reflection.classloader.Dummy");
            ClassLoader acl = dummy.getClassLoader();

            System.out.println("Classloader for dummy: " + acl);

            // UNIQUENESS
            // Builtin ClassLoader always checks if a class has already been loaded. If it is, it simply does nothing and returns
            // If we only need to determine if the class exists or not, then resolve  (initialize) parameter is set to false, but if we want to load it, resolve is true
            Class.forName("hr.algebra.reflection.classloader.Dummy", true, acl); // this one does not do it again!

            // if we do not provide implementation of CustomClassLoader, it delegates to parent, and parent finds out that it is already loaded!
            // but, if we override the loadClass(String, boolean), we change the behavior  -> we should have fixed this
            // this one loads it again
            Class.forName("hr.algebra.reflection.classloader.Dummy", true, new DummyClassLoader());

            // VISIBILITY: classes loaded by parent ClassLoader are visible by child ClassLoader, but not vice-versa

            // all this classes are loaded by PlatformClassLoader (ExtClassLoader)
            Class.forName("java.sql.Array", true, acl); // child can load (acl can load something from pcl)
            Class.forName("java.sql.Blob", true, acl.getParent()); // itself can load (pcl)
            Class.forName("java.sql.Clob", true, acl.getParent().getParent()); // parent can not load (bcl)

        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}
