package hr.algebra.reflection.classloader;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;

public class DummyClassLoader extends ClassLoader {

    private static final String PATH = "target/classes/"; // this path is from Intellij Maven project
    private static final String EXT = ".class";

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Objects.requireNonNull(name); // fail fast
        if (!Dummy.class.getName().equals(name)) {
            return super.loadClass(name, resolve);
        }

        String filename = "%s%s%s".formatted(PATH, name.replace('.', File.separatorChar), EXT); // this replaces all '.' chars

        byte[] bytes = loadClassManually(filename);

        return defineClass(name, bytes, 0, bytes.length);
    }

    private byte[] loadClassManually(String filename) throws ClassNotFoundException {
        try {
            return Files.readAllBytes(Paths.get(filename));
        } catch (Exception e) {
            throw new ClassNotFoundException();// adjusting to caller signature
        }
    }
}
