package hr.algebra.concurrency.locks;

public class DeadLockDemo {
    public static void main(String[] args) {

        //problem();
        solution(); // always preserve ordering of acquiring resources
    }

    private static void problem() {
        final Object a = new Object();
        final Object b = new Object();

        new Thread(() -> {
            System.out.println(Thread.currentThread() + " acquiring resource A");
            synchronized (a) {
                System.out.println(Thread.currentThread() + " has resource A");
                try {
                    // Adding delay so that both threads can start trying to
                    // lock resources
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                // Thread-1 have A but need B also
                System.out.println(Thread.currentThread() + " acquiring resource B");
                synchronized (b) {
                    System.out.println(Thread.currentThread() + " has resource B");
                }
            }
        }).start();

        new Thread(() -> {
            System.out.println(Thread.currentThread() + " acquiring ResourceB");
            synchronized (b) {
                System.out.println(Thread.currentThread() + " has resource B");
                // Thread-1 have B but need A also
                System.out.println(Thread.currentThread() + " acquiring resource A");
                synchronized (a) {
                    System.out.println(Thread.currentThread() + " has resource A");
                }
            }
        }).start();

    }

    private static void solution() {
        final Object a = new Object();
        final Object b = new Object();

        new Thread(() -> {
            System.out.println(Thread.currentThread() + " acquiring resource A");
            synchronized (a) {
                System.out.println(Thread.currentThread() + " has resource A");
                try {
                    // Adding delay so that both threads can start trying to
                    // lock resources
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                // Thread-1 have A but need B also
                System.out.println(Thread.currentThread() + " acquiring ResourceB");
                synchronized (b) {
                    System.out.println(Thread.currentThread() + " has ResourceB");
                }
            }
        }).start();

        new Thread(() -> {
            System.out.println(Thread.currentThread() + " acquiring resource B");
            synchronized (a) {
                System.out.println(Thread.currentThread() + " has resource A");
                // Thread-1 have A but need B also
                System.out.println(Thread.currentThread() + " acquiring ResourceB");
                synchronized (b) {
                    System.out.println(Thread.currentThread() + " has resource b");
                }
            }
        }).start();
    }
}
