package hr.algebra.concurrency.locks;

import hr.algebra.concurrency.utilities.ThreadUtils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedDemo {
    public static void main(String[] args) {
        runCounter();
    }

    private static void runCounter() {
        Counter counter = new Counter(); // shared resource

        ExecutorService executorService = Executors.newFixedThreadPool(2);

        Lock lock  = new ReentrantLock();
        Runnable runnable = () -> {
            while (!Thread.interrupted()) {
                //synchronized (counter) {
                lock.lock();
                try {
                    counter.increment(); // ctrl + alt + t
                } finally {
                    lock.unlock();
                }
                //}
            }
        };

        executorService.execute(runnable);
        executorService.execute(runnable);

        ThreadUtils.stopExecutor(executorService, 6, TimeUnit.SECONDS);
    }
}
