package hr.algebra.serialization;

import hr.algebra.serialization.singleton.EagerElvis;
import hr.algebra.serialization.singleton.ElvisEnumis;
import hr.algebra.serialization.singleton.LazyElvis;
import hr.algebra.utilities.SerializationUtils;

import java.io.IOException;

public class ElvisUsage {
    private static final String FILENAME = "king_of_rock.ser";

    public static void main(String[] args) {

       //LazyElvis elvis = LazyElvis.getInstance();
        //EagerElvis elvis = EagerElvis.INSTANCE;
        ElvisEnumis elvis = ElvisEnumis.INSTANCE;
        // hashcode() - the method in java.lang.Object is declared as native, which means the implementation is provided by the JVM and may vary depending on your runtime environment.
        System.out.println(elvis.hashCode());
        System.out.println(elvis); // to string gives className@hashcode() in hex

        try {
            SerializationUtils.write(elvis, FILENAME);
            elvis = SerializationUtils.read(FILENAME);
            System.out.println(elvis.hashCode());
            System.out.println(elvis);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}
