package hr.algebra.serialization.model;

import java.io.*;
import java.util.Objects;

public final class Student extends Person implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;


    private final transient int yearOfStudy;
    private final Index index;

    public Student(String firstName, String lastName, int yearOfStudy, Index index) {
        super(firstName, lastName);
        this.yearOfStudy = yearOfStudy;
        this.index = index;
    }

    @Override
    public String toString() {
        return "Student{" +
                ", yearOfStudy=" + yearOfStudy +
                ", index=" + index +
                "} " + super.toString();
    }

    @Serial
    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeUTF(getFirstName());
        oos.writeUTF(getLastName());
    }

    @Serial
    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        Objects.requireNonNull(index.getIssuer());
        setFirstName(ois.readUTF());
        setLastName(ois.readUTF());
    }
}
