package hr.algebra.serialization.singleton;

import java.io.Serial;
import java.io.Serializable;

public class EagerElvis implements Serializable {

    @Serial
    private static final long serialVersionUID = 6L;

    //private static final EagerElvis INSTANCE = new EagerElvis();
    public static final EagerElvis INSTANCE = new EagerElvis();

    private EagerElvis() {
    }

    // since we are sending the very same object, we do not need to encapsulate the original variable
    // we just want to provide to our clients the Singleton instance
		/*
		public static EagerElvis getInstance() {
			return INSTANCE;
		}
		*/

    private Object readResolve() {
        // Return the one true Elvis and let the garbage collector
        // take care of the Elvis impersonator.
        return INSTANCE;
    }

}
