package hr.algebra.enums;

import java.util.function.DoubleBinaryOperator;

//public enum Operation {
//    PLUS, MINUS, TIMES, DIVIDE;
//
//    PROBLEM: whenever we add new Operation, we must add new case block! - very easy to make a mistake!!!
//    public double applyAsDouble(double a, double b) {
//        switch (this) {
//            case PLUS:      return a + b;
//            case MINUS:     return a - b;
//            case TIMES:     return a * b;
//            case DIVIDE:    return b == 0 ? 0 : a / b;
//        }
//        throw new AssertionError("Unknown operation: " + this);
//        //Assertions should only be used to verify conditions that should be logically impossible to be false (read: sanity checks).
//    }

//    // 2024 -> just show, but get back to previous solution
//    public double applyAsDouble(double a, double b) {
//        return switch (this) {
//            case PLUS -> a + b;
//            case MINUS -> a - b;
//            case TIMES -> a * b;
//            case DIVIDE -> b == 0 ? 0 : a / b;
//        };
//    }
//}


//public enum Operation implements DoubleBinaryOperator {
//    PLUS("+") {
//        @Override
//        public double applyAsDouble(double a, double b) {
//            return a + b;
//        }
//    },
//    MINUS("-") {
//        @Override
//        public double applyAsDouble(double a, double b) {
//            return a - b;
//        }
//    },
//    TIMES("*") {
//        @Override
//        public double applyAsDouble(double a, double b) {
//            return a * b;
//        }
//    },
//    DIVIDE("/") {
//        @Override
//        public double applyAsDouble(double a, double b) {
//            return b == 0 ? 0 : a / b;
//        }
//    };
//
//    private final String symbol;
//
//    // The constructor for an enum type must be package-private or private access. It automatically creates the constants that are defined
//    // at the beginning of the enum body. You cannot invoke an enum constructor yourself.
//    Operation(String symbol) {
//        this.symbol = symbol;
//    }
//
//    // it is only possible to broaden overridden method not to restrict it
//    // subclasses must have the same interface! LISKOV
//    @Override
//    public String toString() {
//        return symbol;
//    }
//}


// prefer composition over inheritance - maybe we can totally depend on constructor!!!
public enum Operation {
    PLUS("+", Double::sum),
    MINUS("-", (a, b) -> a - b),
    TIMES("*", (a, b) -> a * b),
    DIVIDE("/", (a, b) -> b == 0 ? 0 : a / b);

    private final String symbol;
    private final DoubleBinaryOperator operator;

    Operation(String symbol, DoubleBinaryOperator operator) {
        this.symbol = symbol;
        this.operator = operator;
    }

    @Override
    public String toString() {
        return symbol;
    }

    public double applyAsDouble(double a, double b) {
        return operator.applyAsDouble(a, b);
    }
}
