package hr.algebra.trirp1.tictactoe.tictactoe3rp11.thread;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameMove;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.FileUtils;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTheLastGameMoveThread {

    public synchronized void saveTheLastGameMove(GameMove gameMove) throws FileNotFoundException {

        while (FileUtils.FILE_ACCESS_IN_PROGRESS) {
            try {
                wait();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        List<GameMove> gameMoves = new ArrayList<>();
        if(Files.exists(Path.of(FileUtils.GAME_MOVE_HISTORY_FILE_NAME))){
            List<GameMove> lastGameMoves = loadGameMoves();
            gameMoves.addAll(lastGameMoves);
        }
        gameMoves.add(gameMove);

        try(ObjectOutputStream oos = new ObjectOutputStream(
                new FileOutputStream(FileUtils.GAME_MOVE_HISTORY_FILE_NAME))) {
            oos.writeObject(gameMoves);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        FileUtils.FILE_ACCESS_IN_PROGRESS = false;

        notifyAll();
    }

    public synchronized List<GameMove> loadGameMoves() {

        while (FileUtils.FILE_ACCESS_IN_PROGRESS) {
            try {
                wait();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        FileUtils.FILE_ACCESS_IN_PROGRESS = true;

        List<GameMove> gameMoves = new ArrayList<>();

        if(Files.exists(Path.of(FileUtils.GAME_MOVE_HISTORY_FILE_NAME))) {
            try (ObjectInputStream ois = new ObjectInputStream(
                    new FileInputStream(FileUtils.GAME_MOVE_HISTORY_FILE_NAME)))
            {
                List<GameMove> lastGameMoves = (List<GameMove>) ois.readObject();
                gameMoves.addAll(lastGameMoves);
            } catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        FileUtils.FILE_ACCESS_IN_PROGRESS = false;

        notifyAll();

        return gameMoves;
    }

}
