package hr.algebra.trirp1.tictactoe.tictactoe3rp11.controller;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameState;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.Symbol;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.DialogUtils;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.GameUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import static hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.GameUtils.*;

public class TicTacToeMainController {
    @FXML
    private Button buttontl;

    @FXML
    private Button buttontc;

    @FXML
    private Button buttontr;

    @FXML
    private Button buttonml;

    @FXML
    private Button buttonmc;

    @FXML
    private Button buttonmr;

    @FXML
    private Button buttonbl;

    @FXML
    private Button buttonbc;

    @FXML
    private Button buttonbr;

    private Symbol turn = Symbol.X;

    private static final Button[][] board
            = new Button[GameUtils.NUMBER_OF_ROWS][GameUtils.NUMBER_OF_COLUMNS];

    private static Integer numberOfMoves = 0;

    public void initialize() {
        board[0][0] = buttontl;
        board[0][1] = buttontc;
        board[0][2] = buttontr;
        board[1][0] = buttonml;
        board[1][1] = buttonmc;
        board[1][2] = buttonmr;
        board[2][0] = buttonbl;
        board[2][1] = buttonbc;
        board[2][2] = buttonbr;

        numberOfMoves = 0;
    }

    public void buttonPressed(ActionEvent event) {

        numberOfMoves++;
        boolean winnerExists = false;

        if (event.getSource() instanceof Button b
                && b.getText().isEmpty()) {
            b.setText(turn.name());
        }

        winnerExists = GameUtils.winnerExists(board, turn);

        if (turn.equals(Symbol.X)) {
            turn = Symbol.O;
        } else {
            turn = Symbol.X;
        }

        if(winnerExists) {
            numberOfMoves = 0;
        }
        else if (!winnerExists &&
                numberOfMoves == NUMBER_OF_ROWS * NUMBER_OF_COLUMNS) {
            DialogUtils.showDialog("Nema pobjednika!",
                    "Nijedan igrač nije pobijedio!",
                    Alert.AlertType.INFORMATION);
            numberOfMoves = 0;
        }
    }

    public void startNewGame() {
        GameUtils.startNewGame(board);
    }

    public void saveGame() {
        String[][] symbolBoard = new String[NUMBER_OF_ROWS][NUMBER_OF_COLUMNS];

        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                symbolBoard[i][j] = board[i][j].getText();
            }
        }

        // Could be rewritten using streams like this:
        // symbolBoard = IntStream.range(0, NUMBER_OF_ROWS)
        //     .mapToObj(i -> IntStream.range(0, NUMBER_OF_COLUMNS)
        //         .mapToObj(j -> board[i][j].getText())
        //         .toArray(String[]::new))
        //     .toArray(String[][]::new);

        GameState gameStateToSave = new GameState(symbolBoard, turn);
        GameUtils.saveGame(gameStateToSave);
    }

    public void loadGame() {
        GameState loadedGameState = GameUtils.loadGame();
        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                board[i][j].setText(loadedGameState.getBoard()[i][j]);
            }
        }

        // Could be rewritten using streams like this:
        // IntStream.range(0, NUMBER_OF_ROWS).forEach(i ->
        //     IntStream.range(0, NUMBER_OF_COLUMNS).forEach(j ->
        //         board[i][j].setText(loadedGameState.getBoard()[i][j])
        //     )
        // );
    }
}