package hr.algebra;

import javafx.application.Application;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.*;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

import java.util.Arrays;
import java.util.List;

public class LayoutsApplication extends Application {
    @Override
    public void start(Stage stage)/* throws IOException*/ { // LISKOV
        //Parent root = generateHBox();
        //Parent root = generateVBox();
        //Parent root = generateFlowPane();
        //Parent root = generateBorderPane();
        Parent root = generateGridPane();

        Scene scene = new Scene(root, 800, 680);

        stage.setTitle("Layouts");
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        launch();
    }

    private Parent generateHBox() {
        HBox hbox = new HBox(5);
        hbox.setPadding(new Insets(1));
        List<Rectangle> rectangles = Arrays.asList(
                new Rectangle(100, 100),
                new Rectangle(200, 200),
                new Rectangle(50, 200),
                new Rectangle(200, 50));
        rectangles.forEach(r -> HBox.setMargin(r, new Insets(10, 10, 10, 10)));
        hbox.getChildren().addAll(rectangles);

        return hbox;
    }

    private Parent generateVBox() {
        VBox vbox = new VBox(5);
        vbox.setPadding(new Insets(1));
        List<Rectangle> rectangles = Arrays.asList(
                new Rectangle(100, 100),
                new Rectangle(200, 200),
                new Rectangle(50, 200),
                new Rectangle(200, 50));
        rectangles.forEach(r -> VBox.setMargin(r, new Insets(10, 10, 10, 10)));
        vbox.getChildren().addAll(rectangles);
        return vbox;
    }

    private Parent generateFlowPane() {
        FlowPane flowPane = new FlowPane();
        List<Button> buttons = Arrays.asList(
                new Button("First"),
                new Button("Second"),
                new Button("Third"),
                new Button("Fourth"),
                new Button("Fifth"),
                new Button("Sixth"),
                new Button("Seventh"),
                new Button("Eighth"),
                new Button("Ninth"),
                new Button("Tenth"));
        flowPane.setAlignment(Pos.TOP_RIGHT);
        flowPane.getChildren().addAll(buttons);
        return flowPane;
    }

    private Parent generateBorderPane() {
        BorderPane borderPane = new BorderPane();
        List<Button> buttons = Arrays.asList(
                new Button("Up"),
                new Button("Left"),
                new Button("Middle"),
                new Button("Right"),
                new Button("Down"));
        BorderPane.setAlignment(buttons.get(0), Pos.TOP_CENTER);
        borderPane.setTop(buttons.get(0));
        borderPane.setLeft(buttons.get(1));
        borderPane.setCenter(buttons.get(2));
        borderPane.setRight(buttons.get(3));
        BorderPane.setAlignment(buttons.get(4), Pos.BOTTOM_CENTER);
        borderPane.setBottom(buttons.get(4));
        return borderPane;
    }

    private Parent generateGridPane() {
        GridPane gridpane= new GridPane();
        List<Label> labels = Arrays.asList(
                new Label("First Name"),
                new Label("Last Name"));
        List<TextField> textFields = Arrays.asList(
                new TextField(),
                new TextField());
        GridPane.setHalignment(labels.get(0), HPos.RIGHT);
        gridpane.add(labels.get(0), 0, 0);
        GridPane.setHalignment(labels.get(1), HPos.RIGHT);
        gridpane.add(labels.get(1), 0, 1);
        GridPane.setHalignment(textFields.get(0), HPos.LEFT);
        gridpane.add(textFields.get(0), 1, 0);
        GridPane.setHalignment(textFields.get(1), HPos.LEFT);
        gridpane.add(textFields.get(1), 1, 1);
        return gridpane;
    }

}