package hr.algebra.trirp1.tictactoe.tictactoe3rp11;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameState;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.PlayerType;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.Symbol;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.DialogUtils;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.Stage;

import javax.swing.*;
import java.io.*;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;

public class TicTacToeApplication extends Application {

    public static PlayerType playerType;
    public static final int PORT = 1989;
    public static final String HOST = "localhost";

    @Override
    public void start(Stage stage) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(TicTacToeApplication.class.getResource("tic-tac-toe.fxml"));
        Scene scene = new Scene(fxmlLoader.load());
        stage.setTitle("Križić - kružić - " + playerType.toString());
        stage.setScene(scene);
        stage.show();

        if(!PlayerType.SINGLE_PLAYER.equals(playerType.name())) {
            if (PlayerType.PLAYER_2.name().equals(playerType.name())) {

                Thread serverThread = new Thread(() -> acceptRequests());
                serverThread.start();

//                Platform.runLater(
//                        () -> acceptRequests()
//                );
            }
        }
    }

    public static void main(String[] args) {

        String firstCommandLineArg = args[0];

        Boolean playerTypeExists = false;

        for (PlayerType playerType : PlayerType.values()) {
            if (firstCommandLineArg.equals(playerType.toString())) {
                playerTypeExists = true;
                break;
            }
        }

        if(!playerTypeExists) {
            System.out.println("You provided a player type that does not exist!");
            JOptionPane.showMessageDialog(null,
                    "You provided a player type that does not exist!");
            System.exit(0);
        }
        else {
            playerType = PlayerType.valueOf(firstCommandLineArg);
            launch();
        }
    }

    private static void acceptRequests() {
        try (ServerSocket serverSocket = new ServerSocket(PORT)){
            System.err.printf("[%s] Server listening on port: %d%n", playerType, serverSocket.getLocalPort());

            while (true) {
                Socket clientSocket = serverSocket.accept();
                System.err.printf("[%s] Client connected from port %s%n", playerType, clientSocket.getPort());
                new Thread(() ->  processSerializableClient(clientSocket)).start();
            }
        }  catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void processSerializableClient(Socket clientSocket) {
        try (ObjectInputStream ois = new ObjectInputStream(clientSocket.getInputStream());
             ObjectOutputStream oos = new ObjectOutputStream(clientSocket.getOutputStream());){
            GameState gameState = (GameState)ois.readObject();
            System.out.println("[" + playerType + "] Game state received from Player 1");
            oos.writeObject("Success");
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void sendRequest(GameState gameState) {
        try (Socket clientSocket = new Socket(HOST, PORT)){
            System.err.printf("[%s] Client is connecting to %s:%d%n", playerType, clientSocket.getInetAddress(), clientSocket.getPort());

            sendSerializableRequest(clientSocket, gameState);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void sendSerializableRequest(Socket client, GameState gameState) throws IOException, ClassNotFoundException {
        ObjectOutputStream oos = new ObjectOutputStream(client.getOutputStream());
        ObjectInputStream ois = new ObjectInputStream(client.getInputStream());
        oos.writeObject(gameState);
        System.out.println("[" + playerType + "] GameState sent to Player2");
        System.out.println("[" + playerType + "] " + ois.readObject());
    }
}