package hr.algebra.serialization;

import hr.algebra.serialization.model.Country;
import hr.algebra.utilities.SerializationUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CountryUsage {

    private static final String FILENAME = "countries.ser";

    public static void main(String[] args) {
        List<Country> countries = List.of(
                new Country("Croatia", 1),
                new Country("Italia", 2),
                new Country("Germany", 3)
        );
        System.out.println(countries);

        try {
            // since List<T> does not implement Serializable, but ArrayList does, we have to send our utility a proper serializable!
            SerializationUtils.write(new ArrayList<>(countries), FILENAME);
            countries = SerializationUtils.read(FILENAME);
            System.out.println(countries);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}
