package hr.algebra.networking.udp.multicast;

import java.io.IOException;
import java.net.*;

public class ClientThread extends Thread {

    public ClientThread(String name) {
        super(name);
    }

    @Override
    public void run() {
        // we use new Socket for each client call
        try (MulticastSocket clientSocket = new MulticastSocket(ServerThread.CLIENT_PORT)) {

            InetAddress group = InetAddress.getByName(ServerThread.GROUP);
            InetSocketAddress groupAddress = new InetSocketAddress(group, ServerThread.CLIENT_PORT); // 65533
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(ServerThread.HOST));

            System.err.printf("%s joining group%n", getName());
            clientSocket.joinGroup(groupAddress, networkInterface);

            System.err.printf(" %s listening...%n", getName());

            for (int i = 0; i < 3; i++) {
                byte[] buffer = new byte[64];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                clientSocket.receive(packet);
                String message = new String(packet.getData(), 0, packet.getLength());
                System.out.printf("%s received: %s%n", getName(), message);
            }
            System.err.printf("%s leaving group%n", getName());
            clientSocket.leaveGroup(groupAddress, networkInterface);

        } catch (SocketException | UnknownHostException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
