package hr.algebra.concurrency.threads;

import hr.algebra.concurrency.utilities.ThreadUtils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class Demo {

    public static void main(String[] args) {
        //multipleThreads();
        //priorityThreads();
        //threadGroup();
        threadPool();
    }
    private static void multipleThreads() {
        Thread evenThread = new Thread(() ->
                // first fori -> tab
                IntStream.range(1, 30).filter(n -> n % 2 == 0).forEach(n -> {
                    try {
                        System.out.println(Thread.currentThread().getName() + ": " + n); // static reference!
                        Thread.sleep((long) (Math.random() * 1000));
                    } catch (InterruptedException ex) {
                        Logger.getLogger(Demo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }), "Even thread");
        Thread oddThread = new Thread(() ->
                IntStream.range(1, 30).filter(n -> n % 2 != 0).forEach(n -> {
                    System.out.println(Thread.currentThread().getName() + ": " + n);
                    try {
                        if (n == 15) {
                            System.out.println("Odd thread is waiting for all the evens to finish!");
                            evenThread.join();
                        }
                        Thread.sleep((long)(Math.random() * 1000));
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }), "Odd thread");
        //oddThread.setDaemon(true);

        //evenThread.run(); // this shouldn't be ever called - public interface method problem!
        //oddThread.run();

        evenThread.start();
        oddThread.start();
        System.out.println("Main thread"); // why didn't application stop when Main thread is done?
    }

    private static void priorityThreads() {
        Thread evenThread = new Thread(() ->
                IntStream.range(1, 3000).filter(n -> n % 2 == 0).forEach(n -> {
                    System.out.println(Thread.currentThread().getName() + ": " + n);
                    Thread.yield();
                }), "Even thread");
        Thread oddThread = new Thread(() ->
                IntStream.range(1, 3000).filter(n -> n % 2 != 0).forEach(n -> {
                    System.out.println(Thread.currentThread().getName() + ": " + n);
                }), "Odd thread");

        evenThread.setPriority(Thread.MAX_PRIORITY); // should have been enum!
        oddThread.setPriority(Thread.MIN_PRIORITY); // do in reverse, results should be the opposite!
        evenThread.start();
        oddThread.start();
        System.out.println("Main thread");
    }

    private static class RollingDice extends Thread {

        public RollingDice(ThreadGroup group, String name) {
            super(group, name);
        }

        @Override
        public void run() {
            while (true) {
                int n = (int)(Math.random() * 6) + 1;
                System.out.printf("%s gave: %d%n", getName(), n); // souf -> from C
                try {
                    Thread.sleep((long)(Math.random() * 3000));
                } catch (InterruptedException e) {
                    //e.printStackTrace();
                    return; // very important to quit when interrupted -> interrupt interrupts sleep!
                }
            }
        }
    }

    private static void threadGroup() {
        ThreadGroup threadGroup = new ThreadGroup("The die is cast");
        threadGroup.setMaxPriority(Thread.MAX_PRIORITY);

        Thread[] threads = new Thread[6];
        for (int i = 0; i < threads.length; i++) {
            threads[i] = new RollingDice(threadGroup, "Dice[" + (i + 1) + "]");
            threads[i].start(); // it is bad that the Thread is a mechanism and a business logic!!!
        }

        System.out.println("Active threads: " + threadGroup.activeCount());

        try {
            Thread.sleep(6000);
            threadGroup.interrupt();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void threadPool() {
        ThreadGroup threadGroup = new ThreadGroup("The die is cast");
        threadGroup.setMaxPriority(Thread.MAX_PRIORITY);

        // Cached thread pool executor – Creates a thread pool that creates new threads as needed, but will reuse previously constructed threads when they are available
        ExecutorService executorService = Executors.newCachedThreadPool(); // static constructor

        Thread[] threads = new Thread[6];
        for (int i = 0; i < threads.length; i++) {
            threads[i] = new RollingDice(threadGroup, "Dice[" + (i + 1) + "]");
            executorService.execute(threads[i]); // now executorService represents mechanism
        }
        ThreadUtils.stopExecutor(executorService, 6, TimeUnit.SECONDS);

    }
}
