package hr.algebra.trirp1.tictactoe.tictactoe3rp11.controller;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.TicTacToeApplication;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameState;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.PlayerType;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.Symbol;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.rmi.ChatRemoteService;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.rmi.RmiServer;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.DialogUtils;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.DocumentationUtils;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.GameUtils;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;

import static hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils.GameUtils.*;

public class TicTacToeMainController {

    private static final Logger log
            = LoggerFactory.getLogger(TicTacToeMainController.class);

    @FXML
    private Button buttontl;

    @FXML
    private Button buttontc;

    @FXML
    private Button buttontr;

    @FXML
    private Button buttonml;

    @FXML
    private Button buttonmc;

    @FXML
    private Button buttonmr;

    @FXML
    private Button buttonbl;

    @FXML
    private Button buttonbc;

    @FXML
    private Button buttonbr;

    @FXML
    private TextField chatMessageTextField;

    @FXML
    private TextArea chatMessageTextArea;

    public static Symbol turn = Symbol.X;

    private static final Button[][] board
            = new Button[GameUtils.NUMBER_OF_ROWS][GameUtils.NUMBER_OF_COLUMNS];

    private static Integer numberOfMoves = 0;

    public static Integer gameNumber = 0;

    ChatRemoteService chatRemoteService;

    public void initialize() {
        board[0][0] = buttontl;
        board[0][1] = buttontc;
        board[0][2] = buttontr;
        board[1][0] = buttonml;
        board[1][1] = buttonmc;
        board[1][2] = buttonmr;
        board[2][0] = buttonbl;
        board[2][1] = buttonbc;
        board[2][2] = buttonbr;

        numberOfMoves = 0;

        if (PlayerType.PLAYER_2.name().equals(TicTacToeApplication.playerType.name())) {
            disableButtons(true);
        } else if (PlayerType.PLAYER_1.name().equals(TicTacToeApplication.playerType.name())) {
            disableButtons(false);
        }

        gameNumber++;

        try {
            Registry registry = LocateRegistry.getRegistry(RmiServer.HOSTNAME, RmiServer.RMI_PORT);
            chatRemoteService = (ChatRemoteService) registry.lookup(ChatRemoteService.REMOTE_OBJECT_NAME);
        } catch (RemoteException | NotBoundException e) {
            e.printStackTrace();
        }

        Timeline chatMessagesRefreshTimeLine = getChatRefreshTimeline();
        chatMessagesRefreshTimeLine.play();
    }

    private Timeline getChatRefreshTimeline() {
        Timeline chatMessagesRefreshTimeLine = new Timeline(new KeyFrame(Duration.ZERO, e -> {
            try {
                List<String> chatMessages =  chatRemoteService.getAllMessages();

                StringBuilder textMessagesBuilder = new StringBuilder();

                for(String message : chatMessages) {
                    textMessagesBuilder.append(message).append("\n");
                }

                chatMessageTextArea.setText(textMessagesBuilder.toString());

            } catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        }

        ),
                new KeyFrame(Duration.seconds(1))
        );
        chatMessagesRefreshTimeLine.setCycleCount(Animation.INDEFINITE);
        return chatMessagesRefreshTimeLine;
    }

    public void buttonPressed(ActionEvent event) {

        numberOfMoves++;
        boolean winnerExists = false;

        if (event.getSource() instanceof Button b
                && b.getText().isEmpty()) {
            b.setText(turn.name());

            GameState gameState = GameUtils.generateGameState(board, turn, false, numberOfMoves);

            if (TicTacToeApplication.playerType.name().equals(PlayerType.PLAYER_1.name())) {
                TicTacToeApplication.sendRequestPlayerOne(gameState);
            } else if (TicTacToeApplication.playerType.name().equals(PlayerType.PLAYER_2.name())) {
                TicTacToeApplication.sendRequestPlayerTwo(gameState);
            }

        }

        winnerExists = GameUtils.winnerExists(board, turn);

        if (winnerExists) {
            numberOfMoves = 0;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
        }

        if (!winnerExists && numberOfMoves == NUMBER_OF_ROWS * NUMBER_OF_COLUMNS) {
            DialogUtils.showDialog("Nema pobjednika!",
                    "Nijedan igrač nije pobijedio!",
                    Alert.AlertType.INFORMATION);
            numberOfMoves = 0;
        }


        if (turn.equals(Symbol.X)) {
            turn = Symbol.O;
        } else {
            turn = Symbol.X;
        }

        disableButtons(true);
    }

    public void startNewGame() {
        GameUtils.startNewGame(board);
    }

    public void saveGame() {
        GameState gameStateToSave = GameUtils.generateGameState(board, turn, false, numberOfMoves);
        GameUtils.saveGame(gameStateToSave);
    }

    public void loadGame() {
        loadGameState(GameUtils.loadGame());
    }

    public static void loadGameState(GameState gameState) {
        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                board[i][j].setText(gameState.getBoard()[i][j]);
            }
        }

        if (turn.name().equals(Symbol.X.name())) {
            turn = Symbol.O;
        } else {
            turn = Symbol.X;
        }

        numberOfMoves = gameState.getNumberOfTurns();
    }

    public void generateDocumentation() {
        try {
            DocumentationUtils.generateHtmlDocumentationFile();
            DialogUtils.showDialog("Uspješno generirana dokumentacija!",
                    "HTML dokumentacija za aplikaciju je uspješno generirana!",
                    Alert.AlertType.INFORMATION);
        } catch (IOException e) {
            String message = "Došlo je do pogreške kod generiranja HTML dokumentacije!";
            DialogUtils.showDialog("Pogreška!",
                    message,
                    Alert.AlertType.INFORMATION);
            log.error(message, e);
        }
    }

    public static void restoreGameState(GameState gameState) {
        Platform.runLater(() -> loadGameState(gameState));

    }

    public static void disableButtons(Boolean disable) {
        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                board[i][j].setDisable(disable);
            }
        }
    }

    public void sendChatMessage() {
        String chatMessage = chatMessageTextField.getText();
        try {
            chatRemoteService.sendChatMessage(TicTacToeApplication.playerType + ": " + chatMessage);
        } catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}