package hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.Symbol;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;

public class GameUtils {

    public static final Integer NUMBER_OF_ROWS = 3;
    public static final Integer NUMBER_OF_COLUMNS = 3;

    public static void startNewGame(Button[][] board) {
        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                board[i][j].setText("");
            }
        }
    }

    public static boolean winnerExists(Button[][] board, Symbol turn) {

        boolean winnerExists = false;

        for (int i = 0; i < GameUtils.NUMBER_OF_COLUMNS; i++) {
            if (board[i][0].getText().equals(turn.name()) &&
                    board[i][1].getText().equals(turn.name()) &&
                    board[i][2].getText().equals(turn.name())) {
                winnerExists = true;
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION);
            }

            if (board[0][i].getText().equals(turn.name()) &&
                    board[1][i].getText().equals(turn.name()) &&
                    board[2][i].getText().equals(turn.name())) {
                winnerExists = true;
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION);
            }
        }

        if (board[0][0].getText().equals(turn.name()) &&
                board[1][1].getText().equals(turn.name()) &&
                board[2][2].getText().equals(turn.name())) {
            winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
        }

        if (board[2][0].getText().equals(turn.name()) &&
                board[1][1].getText().equals(turn.name()) &&
                board[0][2].getText().equals(turn.name())) {
            winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
        }
        return winnerExists;
    }



}
