package hr.algebra.reflection.factory;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class ShapeFactory {
    private ShapeFactory() {
    }

    public static Shape getShape(String className) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Objects.requireNonNull(className);
        return (Shape) Class.forName(className).getDeclaredConstructor().newInstance();
    }
}
