package hr.algebra.jndi;

import com.sun.jndi.fscontext.RefFSContext;
import com.sun.jndi.fscontext.RefFSContextFactory;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Scanner;

public class FilesUsage {
    private static final String INITIAL_CONTEXT_FACTORY = RefFSContextFactory.class.getName();
    private static final String PROVIDER_URL = "file:c:/"; // comment out listBindings

    public static void main(String[] args) {
        try(InitialDirContextCloseable context = new InitialDirContextCloseable(configureEnvironment())) {
            listBindings(context, "", 1, 2);
            searchBindings(context);
        } catch (NamingException e) {
            e.printStackTrace();
        }
    }
    private static Hashtable<?, ?> configureEnvironment() {
        return new Hashtable<>(){
            {
                put(Context.INITIAL_CONTEXT_FACTORY, INITIAL_CONTEXT_FACTORY);
                put(Context.PROVIDER_URL, PROVIDER_URL);
            }
        };
    }

    private static void listBindings(Context context, String path, int level, int limit) throws NamingException {
        if (level > limit) return;
        NamingEnumeration<Binding> listBindings = context.listBindings(path);
        while (listBindings.hasMoreElements()) {
            Binding binding = listBindings.nextElement();
            System.out.println(binding);
            System.out.printf("%" + level + "s", " ");
            //System.out.println(binding.getName());

            if (RefFSContext.class.getName().equals(binding.getClassName())) {
                listBindings(context, path + File.separator + binding.getName(), level + 1, limit);
            }
        }
    }

    private static void searchBindings(Context context) throws NamingException {
        System.out.print("Insert filename: ");
        String filename = read(System.in);
        Object object = context.lookup(filename);
        if (object instanceof Context ctx) {
            listBindings(ctx, "", 1, 2);
        } else {
            System.out.println(object);
        }
    }

    private static String read(InputStream in) {
        try(Scanner scanner = new Scanner(in)) {
            return scanner.next();
        }
    }


}
