package hr.algebra.serialization.singleton;

import java.io.Serial;
import java.io.Serializable;

public final class LazyElvis implements Serializable {

    @Serial
    private static final long serialVersionUID = 4L;

    private static volatile LazyElvis instance;  //volatile -> every read/write will be from/in main memory, and not CPU cache

    public static LazyElvis getInstance() {
        if (instance == null) {
            //uses the class instance as a monitor.
            // As there is only one class instance (the object representing the class metadata at runtime) one thread can be in this block
            synchronized (LazyElvis.class) {
                if (instance == null) { //double-checked locking - another thread can create INSTANCE in the meantime
                    instance = new LazyElvis();
                }
            }
        }
        return instance;
    }

    @Serial
    private Object readResolve() {
        // Return the one true Elvis and let the garbage collector
        // take care of the Elvis impersonator.
        return instance;
    }
}
