package hr.algebra.networking.tcp;

import java.io.*;
import java.net.ServerSocket;
import java.net.Socket;

public class Server {
    //public static final String HOST = "127.0.0.1"; // loopback
    public static final String HOST = "localhost";
    // The port numbers in the range from 0 to 1023 are the well-known ports or system ports -> https://en.wikipedia.org/wiki/List_of_TCP_and_UDP_port_numbers
    public static final int PORT = 1989;

    public static void main(String[] args) {
        acceptRequests();
    }

    private static void acceptRequests() {
        try (ServerSocket serverSocket = new ServerSocket(PORT)){
            System.err.printf("Server listening on port: %d%n", serverSocket.getLocalPort()); // serr + tab

            while (true) {
                Socket clientSocket = serverSocket.accept();
                System.err.printf("Client connected from port %d%n", clientSocket.getPort());
                // outer try catch blocks cannot handle the anonymous implementations
                //new Thread(() ->  processPrimitiveClient(clientSocket)).start();
                new Thread(() ->  processSerializableClient(clientSocket)).start();
            }
        }  catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void processPrimitiveClient(Socket clientSocket) {
        // we have to manually close dis and dos since clientSocket is not in try with resources
        // closing the streams closes the socket!
        try (DataInputStream dis = new DataInputStream(clientSocket.getInputStream());
             DataOutputStream dos = new DataOutputStream(clientSocket.getOutputStream())) {

            String message = dis.readUTF();
            System.out.printf("Server received: %s%n", message);
            dos.writeInt(countVowels(message));

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int countVowels(String message) {
        return message
                .toLowerCase()
                .replaceAll("[^aeiou]", "")
                .length();
    }

    private static void processSerializableClient(Socket clientSocket) {
        try (ObjectInputStream ois = new ObjectInputStream(clientSocket.getInputStream());
             ObjectOutputStream oos = new ObjectOutputStream(clientSocket.getOutputStream());){
            Country country = (Country)ois.readObject();
            System.out.printf("The client lives in %s%n", country);
            country.setName("Ireland");
            oos.writeObject(country);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}
