package hr.algebra.networking.udp.unicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class ServerThread extends Thread{

    public static final String HOST = "localhost";
    public static final int PORT = 12345;

    // run cannot throw Exception (RuntimeException yes!) -> LISKOV
    @Override
    public void run() {
        try(DatagramSocket serverSocket = new DatagramSocket(PORT)) {
            System.err.printf("Server listening on port:%s%n", serverSocket.getLocalPort());
            while (true) {
                byte[] buffer = new byte[64]; // 64 bytes are enough for the format
                // length if public -> does it break encapsulation? no, it is final -> must be set in constructor!
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                serverSocket.receive(packet);
                // we have to cut it!
                String format = new String(packet.getData(), 0, packet.getLength());
                InetAddress clientAddress = packet.getAddress();
                int clientPort = packet.getPort();
                System.out.printf("Server received format from %s:%d - %s%n", clientAddress, clientPort, format);

                String message = LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
                buffer = message.getBytes();
                packet = new DatagramPacket(buffer, buffer.length, clientAddress, clientPort);
                serverSocket.send(packet);
            }
        } catch (SocketException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}

