package hr.algebra.serialization;

import hr.algebra.serialization.model.Index;
import hr.algebra.serialization.model.Student;

import java.io.*;

import static hr.algebra.utilities.SerializationUtils.read;
import static hr.algebra.utilities.SerializationUtils.write;

public class SerializationUsage {

    private static final String FILENAME = "student.ser";

    public static void main(String[] args) {
        Student student = new Student(
                "Milica",
                "Krmpotić",
                5,
                new Index(
                        1,
                        "Algebra"
                )
        );
        System.out.println(student);
        try {
            write(student, FILENAME);
            student = (Student) read(FILENAME);
            System.out.println(student);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }


}
