package hr.algebra.model;

import java.util.Optional;

public enum EmployeeTag {
    EMPLOYEE("employee"),
    ID("id"),
    FIRSTNAME("firstname"),
    LASTNAME("lastname"),
    INCOME("income");


    private final String tag;

    EmployeeTag(String tag) {
        this.tag = tag;
    }

    public static Optional<EmployeeTag> of(String tag) {
        for (EmployeeTag e : EmployeeTag.values()) {
            if (e.tag.equals(tag)) {
                return Optional.of(e);
            }
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return tag;
    }
}
