package hr.algebra.reflection.dynamic;

import hr.algebra.reflection.info.Student;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Invocations {
    public static void main(String[] args) {
        try {
            // beware that this is not correct business state, but correct object state
            Student student = Student.class.getDeclaredConstructor().newInstance();
            System.out.println("Default student:");
            System.out.println(student);
            student = generateStudent("Milica", "Krmpotic", 5, 4.8);
            System.out.println("Custom student:");
            System.out.println(student);
            breakEncapsulation(student);
            System.out.println("Broken student:");
            System.out.println(student);

        } catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
    private static Student generateStudent(String firstName, String lastName, int yearOfStudy, double average) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] parameterTypes = {String.class, String.class, int.class, double.class};
        Constructor<Student> constructor = Student.class.getConstructor(parameterTypes);
        return constructor.newInstance(firstName, lastName, yearOfStudy, average);
    }

    private static void breakEncapsulation(Student student) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = student.getClass().getDeclaredMethod("setAverage", double.class);
        method.setAccessible(true);
        method.invoke(student,0);
    }
}
