package hr.algebra.concurrency.communication;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class WarehouseBlockingQueue {
    private static final int MAX_PRODUCTS = 200;
    private final BlockingQueue<Object> products = new LinkedBlockingQueue<>(MAX_PRODUCTS);

    public Object getProduct() throws InterruptedException {
        Object product = products.take(); // throws!
        printStatus();
        return product;
    }

    private void printStatus() {
        products.forEach(p -> System.out.print("|"));
        System.out.println();
    }

    public void addProduct(Object product) throws InterruptedException {
        products.put(product); // throws
        printStatus();
    }
}
