package hr.algebra.concurrency.forkjoin;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;

public class Fibonacci extends RecursiveTask<Long> { // RecursiveAction -> VOID

    private static final int THRESHOLD = 10;
    private volatile long number;

    public Fibonacci(long number) {
        this.number = number;
    }

    private static long calculate(long n) {
        if (n <= 1) return n;
        return calculate(n - 1) + calculate(n - 2);

    }

    @Override
    protected Long compute() {
        long result = -1;
        if (number < THRESHOLD) {
            result = calculate(number);
        } else {
            Fibonacci fibonacci1 = new Fibonacci(number - 1);
            Fibonacci fibonacci2 = new Fibonacci(number - 2);
            ForkJoinTask.invokeAll(fibonacci1, fibonacci2);
            try {
                result = fibonacci1.get() + fibonacci2.get();
            } catch (ExecutionException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}