package hr.algebra.networking.intro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.*;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BasicUrl {
//    private static final String _URL = "https://howtodoinjava.com:443/java/generics/complete-java-generics-tutorial/?a=b&c=d#how_generics_work";
//    private static final String _URL = "https://www.qq.com/";
    // example od 403
    private static final String _URL = "https://www.blitz-cinestar-bh.ba/rss.aspx?id=2682";


    public static void main(String[] args) {

        try {
            URL url = URI.create(_URL).toURL();

//            showDetails(url);
//            showResponseHeader(url);
            showContent(url);
        } catch (MalformedURLException e) { // collapse catch blocks!
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void showDetails(URL url) {
        StringBuilder urlDetails = new StringBuilder(); // discuss StringBuffer
        urlDetails.append(url).append(System.lineSeparator());
        urlDetails.append(url.getProtocol())
                .append(":")
                .append("//")
                .append(url.getAuthority())
//                .append(url.getHost())
//                .append(":")
//                .append(url.getPort())
                .append(url.getFile())
//                .append(url.getPath())
//                .append("?")
//                .append(url.getQuery())
                .append("#")
                .append(url.getRef());

        System.out.println(urlDetails);
    }

    // now change the _URL to "https://www.qq.com/"

    private static void showResponseHeader(URL url) throws IOException {
        URLConnection con = url.openConnection();

        con.setRequestProperty("accept-encoding", "gzip"); // it must come prior reading header fields!!!

        con.getHeaderFields().forEach((key, values) ->  System.out.printf("%s %s%n", key, values));

        // pattern matching (Java17)
        if (con instanceof HttpURLConnection http) http.disconnect();


    }
  private static void showContent(URL url) throws IOException {
        URLConnection con = url.openConnection();

        // faking browser because of 403 (forbidden)
        con.addRequestProperty("user-agent", "Mozilla/5.0");

        try(BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), extractEncoding(con.getContentType())))) {
            br.lines().forEach(System.out::println);

        }

        if (con instanceof HttpURLConnection http) http.disconnect();

    }

    private static Charset extractEncoding(String contentType) {
        return contentType != null ? Charset.forName(contentType.substring(contentType.indexOf("=") + 1)) : StandardCharsets.UTF_8;
    }

}
