package hr.algebra.networking.udp.unicast;

import java.io.IOException;
import java.net.*;

public class ClientThread extends Thread {

    private static final String DATE_TIME_FORMAT = "dd/MM/yyyy hh:mm:ss";

    @Override
    public void run() {
        // we use new Socket for each client call
        while (true) {
            try (DatagramSocket clientSocket = new DatagramSocket()){

                String message = DATE_TIME_FORMAT;
                byte[] buffer = message.getBytes();
                InetAddress serverAddress = InetAddress.getByName(ServerThread.HOST);
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length, serverAddress, ServerThread.PORT);
                clientSocket.send(packet);

                buffer = new byte[64];
                packet = new DatagramPacket(buffer, buffer.length);
                clientSocket.receive(packet);
                String receivedMessage = new String(packet.getData(), 0, packet.getLength());
                System.out.printf("Client received message: %s%n", receivedMessage);

                Thread.sleep(6000);

            } catch (SocketException | UnknownHostException | InterruptedException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
