package hr.algebra.concurrency.communication;

import java.util.LinkedList;
import java.util.Queue;

public class Warehouse {
    private static final int MAX_PRODUCTS = 200;
    private final Queue<Object> products = new LinkedList<>(); // polymorphism in action -> we are looking at linked list as queue (no get(index) method - it is expensive!)

    public synchronized Object getProduct() throws InterruptedException { // cheched exception
        if (products.isEmpty()) {
            wait();
        }
        Object product = products.remove();
        printStatus();
        notify();
        return product;
    }

    private void printStatus() { // can be synchronized -> the thread that holds the lock can enter the method -> RE-ENTRANT LOCK!
        products.forEach(p -> System.out.print("|"));
        System.out.println();
    }

    public synchronized void addProduct(Object product) throws InterruptedException {
        if (products.size() >= MAX_PRODUCTS) {
            wait();
        }
        products.offer(product);
        printStatus();
        notify();
    }
}
