package hr.algebra.parsers;

import hr.algebra.model.Employee;
import hr.algebra.model.EmployeeTag;
import hr.algebra.model.EmployeeType;
import org.w3c.dom.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.File;
import java.util.List;

public class DOMCreator {
    // copy from constants.txt
    private static final String FILENAME = "employees_manual.xml";
    private static final String DTD = "employees.dtd";
    private static final String EMPLOYEES = "employees";
    private static final String TYPE = "type";
    private static final String DOCTYPE = "DOCTYPE";


    public static void main(String[] args) {

        try {
            Document document = createDocument(EMPLOYEES); // immediately saveDocument method!

            List.of(
                    new Employee(1, "Milica", "Krmpotic", 100, EmployeeType.REGULAR),
                    new Employee(2, "Gojko", "Mrnjavcevic", 300, EmployeeType.OUTSOURCED),
                    new Employee(3, "Robert", "MeDiro", 500, EmployeeType.OUTSOURCED)
            ).forEach(employee -> appendEmployeeElement(employee, document));


            saveDocument(document, FILENAME);
        } catch (ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
        }
    }

    private static Document createDocument(String element) throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        DOMImplementation dom = builder.getDOMImplementation();
        DocumentType documentType = dom.createDocumentType(DOCTYPE, null, DTD);
        return dom.createDocument(null, element, documentType);
    }

    private static void saveDocument(Document document, String filename) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
        transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM, document.getDoctype().getSystemId());
        //transformer.transform(new DOMSource(document), new StreamResult(System.out));
        transformer.transform(new DOMSource(document), new StreamResult(new File(filename)));
    }

    private static void appendEmployeeElement(Employee employee, Document document) {
        Element element = document.createElement(EmployeeTag.EMPLOYEE.toString());
        document.getDocumentElement().appendChild(element);

        element.setAttributeNode(createAttribute(document, TYPE, employee.getEmployeeType().toString()));
        element.appendChild(createElement(document, EmployeeTag.ID.toString(), String.valueOf(employee.getId())));
        element.appendChild(createElement(document, EmployeeTag.FIRSTNAME.toString(), String.valueOf(employee.getFirstName())));
        element.appendChild(createElement(document, EmployeeTag.LASTNAME.toString(), String.valueOf(employee.getLastName())));
        element.appendChild(createElement(document, EmployeeTag.INCOME.toString(), String.valueOf(employee.getIncome())));

    }


    private static Attr createAttribute(Document document, String name, String value) {
        Attr attr = document.createAttribute(name);
        attr.setValue(value);
        return attr;
    }

    private static Node createElement(Document document, String tagName, String data) {
        Element element = document.createElement(tagName);
        element.appendChild(document.createTextNode(data));
        return element;
    }

}
