package hr.algebra.concurrency.callable;

import java.util.concurrent.*;

public class Demo {
    public static void main(String[] args) {
        Fibonacci fibonacci = new Fibonacci(40); // if 50 -> it can not be killed, even if we kill it manually -> there is no interruption!

        try (ExecutorService executorService = Executors.newSingleThreadExecutor()){
            Future<Long> result = executorService.submit(fibonacci);
            System.out.println(result.get(1, TimeUnit.SECONDS)); // if not enough, enlarge -> this awaits result!!!
        } catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
    }

}
