package hr.algebra.concurrency.utilities;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    private ThreadUtils() {
    }

    public static void stopExecutor(ExecutorService executorService, int timeout, TimeUnit timeUnit) {
        try {
            executorService.shutdown();
            executorService.awaitTermination(timeout, timeUnit);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }
}
