package hr.algebra.reflection.documentation;

import hr.algebra.reflection.utils.ReflectionUtils;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Demo {
    private static final String CLASSES_PATH = "target/classes/";
    private static final String DOCUMENTATION_PATH = "target/";
    private static final String EXT = ".txt";

    public static void main(String[] args) {
        try {
            Files.walkFileTree(Paths.get(CLASSES_PATH), new SimpleFileVisitor<>(){
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    createDocumentation(file);
                    return super.visitFile(file, attrs);
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createDocumentation(Path path) {
        //System.out.println(path);
        if (path.toString().contains("$")) {
            return;
        }
        String className = StreamSupport.stream(path.spliterator(), false)
                .skip(2)
                .map(p -> p.toString().contains(".") ? p.toString().substring(0, p.toString().indexOf(".")) : p.toString())
                //.forEach(System.out::println);
                .collect(Collectors.joining("."));
        //System.out.println(className);

        try {
            Class<?> clazz = Class.forName(className);
            StringBuilder documentation = new StringBuilder();
            ReflectionUtils.readClassAndMembersInfo(clazz, documentation);

            Files.writeString(Paths.get(DOCUMENTATION_PATH, clazz.getSimpleName() + EXT), documentation.toString());
        } catch (ClassNotFoundException | IOException e) {
            e.printStackTrace();
        }

    }

}
