package hr.algebra.generics.collections;

public class ContainerUsage {
    public static void main(String[] args) {
        int capacity = 5;

        Container<Integer> ints = new Container<>(capacity);
        fill(ints);

        Containers.print("Ints", ints);

        //ints.set(0, 200);
        //ints.set(2, 200);
        ints.set(ints.getSize() - 1, 200);

        Containers.print("Ints after set", ints);

        //ints.remove(0);
        //ints.remove(ints.getSize() - 1);
        ints.remove(2);

        Containers.print("Ints after removal", ints);

        Container<Integer> reversed = Containers.reverse(ints);
        Containers.print("Reversed", reversed);

        Containers.consume(ints, 100);
        Containers.print("Ints after consumer", ints);

        System.out.println("Producer: " + Containers.produce(ints, ints.getSize() - 1));

        //Container<Integer> numbers = new Container<>(ints.getSize());
        //Container<Number> numbers = new Container<>(ints.getSize());
        Container<Object> numbers = new Container<>(ints.getSize());
        Containers.copy(numbers, ints);
        Containers.print("Copy", numbers);

        // no can do!
        //Container<Double> doubles = new Container<>(numbers.getSize());
        //Containers.copy(doubles, numbers);

        System.out.println("Iteration:");
        //  for (int i = 0; i < ints.getSize(); i++) {
        //      System.out.println(ints.get(i));
        //  }
        // this is what Iterable gives us!!!
        //  for (Integer val : ints) {
        //      System.out.println(val);
        //  }
        //  ints.forEach(new Consumer<Integer>() {
        //      @Override
        //      public void accept(Integer val) {
        //          System.out.println(val);
        //      }
        //  });

        ints.forEach(System.out::println);

    }

    private static void fill(Container<Integer> container) {
        for (int i = 0; i < container.capacity; i++) {
            container.add(i + 1);
        }
    }}
