package hr.algebra.generics.collections;

public class Containers {
    private Containers() {
    }
    public static void print(String message, Container<?> container) {
        System.out.println(message);
        System.out.println(container);
    }

    // we use Type because we have to create a reversed container of the same Type
    public static <T> Container<T> reverse(Container<T> source) { // we cannot use <Object> (it would apply only to object), nor <?> which is read only
        Container<T> copy = new Container<>(source.capacity);
        for (int i = source.getSize() - 1; i >= 0; i--) { // we can use for loop
            copy.add(source.get(i));
        }
        return copy;
    }

    // this would work the same:
    //public static <T> void consume(Container<T> container, T ... items) {
    // so, we do not need to use super (in our example) but we want to make official that the "consumer super"
    // it means that the collection of Type and its supertypes can consume the type - polymorphism
    public static <T> void consume(Container<? super T> container, T... items) {
        for (T item : items) {
            container.add(item);
        }
    }

    // PECS principle -> producer extends, consumer super
    // we do not need to use extends (in our example) but we want to make official that the "producer extends"
    // it means that the collection of Type and its subtypes can produce the type - polymorphism
    public static <T> T produce(Container<? extends T> container, int index) {
        return container.get(index);
    }


    public static <T> void copy(Container<? super T> destination, Container<? extends T> source) {
        if (destination.capacity < source.getSize()) throw new IllegalArgumentException("Insufficient capacity");
        // we can do this because of Iterable
        for (T t : source) {
            // we consume in destination, what was produced by the source
            // PECS - Producer Extends, Consumer Super
            destination.add(t);
        }
    }
}
