package hr.algebra.generics.variance;

public class CovariantReifiableArrays {
    public static void main(String[] args) {
        // array of type T[] may contain elements of type T or any subtype of T, so
        // array of type Number[] may contain elements of type Number or any subtype of Number
        Number[] numbers = new Number[3];
        numbers[0] = 1; // autoboxing!!
//        numbers[0] = Integer.valueOf(1); // we do not need boxing!!
        numbers[1] = Double.valueOf(Math.PI);
        numbers[2] = Byte.valueOf((byte) 1); // literal is integer by default

        // arrays are COVARIANT (PROBLEM!):
        // array Integer[] is a subtype of the array Number[] because Integer is a subtype of Number
        Integer[] integers = {1, 2, 3};
        numbers = integers;
        // arrays are a REIFIABLE:
        // at run-time Java knows that this array was actually instantiated as an array of Integers
        // and because of that, this is the trouble, but only in run-time:
        // we can fool the compiler, but we cannot fool the run-time type system
        //numbers[0] = Math.PI; //ArrayStoreException // HEAP POLLUTION

        // what is COVARIANCE good for?
        // this is possible because arrays are COVARIANT - this is a good side to it
        System.out.println("Sum: " + sum(numbers));
        System.out.println("Sum: " + sum(integers));

        // also COVARIANCE!
        // this is possible because of polymophism - we want to have on Generics
        Number n = getLast(numbers);
        n = getLast(integers);
        System.out.println(n);

        // this is also possible, and very problematic
        setLast(numbers, 2.4);
        setLast(integers, 2.4);
    }

    // PRODUCER
    // benefit of COVARIANCE - we want to enable this on Generics
    private static double sum(Number[] numbers) { // Number ...numbers
        double sum = 0;
        for (Number number : numbers) {
            // here we are reading (producing) values! producer in action!
            sum += number.doubleValue();
        }
        return sum;
    }

    // PRODUCER
    private static Number getLast(Number[] numbers) {
        // here we are writing (producing) values! producer in action!
        return numbers[numbers.length - 1];
    }

    // CONSUMER
    // problem of COVARIANCE - we want to prevent this on Generics
    private static void setLast(Number[] numbers, Number number) {
        // here we are writing (consuming) values! consumer in action!
        numbers[numbers.length - 1] = number;
    }
}
