package hr.algebra.enums.patterns.strategy.problem;

// Adding new enum constants (like HOLIDAY) requires updating the switch statement
// Easy to forget updating the logic when adding new days
// Violates the Open/Closed Principle
// Better approach -> Strategy Pattern
public enum PayrollDay {
    MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY;

    private static final int MINS_PER_SHIFT = 8 * 60;

    int pay(int minutesWorked, int payRate) {
        int basePay = minutesWorked * payRate;
        int overtimePay =
            switch (this) {
                case SATURDAY, SUNDAY -> minutesWorked * payRate / 2;
                default -> minutesWorked <= MINS_PER_SHIFT ? 0 : (minutesWorked - MINS_PER_SHIFT) * payRate / 2;
            };
        return basePay + overtimePay;
    }
}
