package hr.algebra.jndi;

import com.sun.jndi.fscontext.RefFSContext;
import com.sun.jndi.fscontext.RefFSContextFactory;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Scanner;

public class LdapUsage {
    private static final String INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    //private static final String INITIAL_CONTEXT_FACTORY = LdapCtxFactory.class.getName();
    private static final String PROVIDER_URL = "ldap://ldap.forumsys.com";
    private static final int TIMEOUT = 30000;


    public static void main(String[] args) {
        try(InitialDirContextCloseable context = new InitialDirContextCloseable(configureEnvironment())) {

            search(context, "dc=example,dc=com", "objectClass=organization");
            search(context, "dc=example,dc=com", "objectClass=top");
            search(context, "dc=example,dc=com", "objectclass=inetOrgPerson");
            search(context, "uid=euclid,dc=example,dc=com", "objectclass=inetOrgPerson");
            search(context, "ou=scientists,dc=example,dc=com", "objectclass=top");

        } catch (NamingException e) {
            e.printStackTrace();
        }
    }

    private static Hashtable<?, ?> configureEnvironment() {
        return new Hashtable<>(){
            {
                put(Context.INITIAL_CONTEXT_FACTORY, INITIAL_CONTEXT_FACTORY);
                put(Context.PROVIDER_URL, PROVIDER_URL);
            }
        };
    }

    private static void search(InitialDirContext context, String name, String filter) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(SearchControls.SUBTREE_SCOPE);
        searchControls.setTimeLimit(TIMEOUT);
        NamingEnumeration<SearchResult> namingEnumeration = context.search(name, filter, searchControls);
        while (namingEnumeration.hasMore()) {
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            System.out.println(attributes);
        }
    }


}
