package hr.algebra.concurrency.callable;

import java.util.concurrent.Callable;

public class Fibonacci implements Callable<Long> {

    private final long number;

    public Fibonacci(long number) {
        this.number = number;
    }

    @Override
    public Long call() {
        return calculate(number);
    }

    private Long calculate(long number) { // careful - variable shading!
        if (number <= 1) return number;
        return calculate(number - 1) + calculate(number - 2);
    }
}
