package hr.algebra.concurrency.communication;

import hr.algebra.concurrency.utilities.ThreadUtils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class WarehouseDemo {
    public static void main(String[] args) {
        //Warehouse warehouse = new Warehouse();
        WarehouseBlockingQueue warehouse = new WarehouseBlockingQueue();

        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);

        scheduledExecutorService.schedule(()-> {
            while (true) {
                warehouse.addProduct(new Object());
            }
        }, 1000, TimeUnit.MILLISECONDS);

        scheduledExecutorService.schedule(()-> {
            while (true) {
                warehouse.getProduct();
            }
        }, 1010, TimeUnit.MILLISECONDS);

        ThreadUtils.stopExecutor(scheduledExecutorService, 10, TimeUnit.SECONDS);

    }
}
