package hr.algebra.utilities;

import org.xml.sax.SAXException;

import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import java.io.File;
import java.io.IOException;

public class XSDValidator {
    private XSDValidator() {
    }

    public static void validate(String xml, String xsd, String uri) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance(uri);
        Schema schema = factory.newSchema(new File(xsd));
        schema.newValidator().validate(new StreamSource(xml));
    }
}
