package hr.algebra.generics;

public class HolderUsage {
    public static void main(String[] args) {
        // sure I can avoid generics, because it must be backward compatible, but I loose all the type safety!
        //Holder holder = new Holder();
        //holder.setValue(1); // this expects an object and holds an object -> I loose type safety!

        // I can use generics, this way:
        //Holder<Integer> intHolder = new Holder<Integer>();
        // but, there is a shortcut -> diamond operator
        Holder<Integer> intHolder = new Holder<>();
        intHolder.setValue(1);

        //ok, but can I use constructor with type param?
        intHolder = new Holder<>(2);

        // diamond explained: if diamond not specified, this is possible:
        //intHolder = new Holder("Milica Krmpotic");
        //int i = intHolder.getValue();

        //Number number = 5; // autobox and promote
        Holder<Number> numHolder = new Holder<>(intHolder.getValue());
        // this also passes, because Number is parent of both Double and Integer
        numHolder = new Holder<>(2.4);

        // so the basics of polymorphism work!

        // this does not pass - we are safe
        //safeSet(intHolder, 1.3);
        // this passes
        safeSet(intHolder, 1);
        safeSet(numHolder, 1); // this does not pass, because we have only <Integer> possibility
        // so, we can translate this into Generics
    }



    private static <T> void safeSet(Holder<T> holder, T value) {
        holder.setValue(value);
    }
}
