package hr.algebra.generics.collections;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Container<E> implements Iterable<E> {

    // we can make readonly variable public, because it is final -> check array.length
    public final int capacity;
    private final E[] items;
    private int size;

    public Container(int capacity) {
        this.capacity = capacity;
        this.items = (E[])new Object[capacity];
    }

    public int getSize() {
        return size;
    }

    public boolean isEmpty() {
        return size == 0;
    }

    public boolean isFull() {
        return size >= capacity;
    }

    public boolean add(E e) {
        if (isFull()) return false;
        items[size++] = e;
        return true;
    }

    public void set(int index, E e) {
        if (index < 0 || index >= size) throw new IndexOutOfBoundsException();
        items[index] = e;
    }

    public E get(int index) {
        if (index < 0 || index >= size) throw new IndexOutOfBoundsException();
        return items[index];
    }

    public void remove(int index) {
        if (index < 0 || index >= size) throw new IndexOutOfBoundsException();
        for (int i = index; i < size - 1 ; i++) {
            items[i] = items[i + 1];
        }
        items[--size] = null; // prevent memory leak! Joshua Bloch
    }

    @Override
    public String toString() {
        return Stream.of(items)
                .map(Objects::toString)
                .collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>() {
            private int currentIndex = 0;
            @Override
            public boolean hasNext() {
                return currentIndex < size;
            }

            @Override
            public E next() {
                return get(currentIndex++);
            }
        };
    }
}
