package hr.algebra.trirp1.tictactoe.tictactoe3rp11.model;

import java.util.Arrays;

public class GameState implements java.io.Serializable {
    private String[][] board;
    private Symbol turn;

    public GameState(String[][] board, Symbol turn) {
        this.board = board;
        this.turn = turn;
    }

    public String[][] getBoard() {
        return board;
    }

    public void setBoard(String[][] board) {
        this.board = board;
    }

    public Symbol getTurn() {
        return turn;
    }

    public void setTurn(Symbol turn) {
        this.turn = turn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GameState gameState = (GameState) o;
        return Arrays.deepEquals(board, gameState.board) && turn == gameState.turn;
    }

    @Override
    public int hashCode() {
        int result = Arrays.deepHashCode(board);
        result = 31 * result + (turn != null ? turn.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "GameState{board=" + Arrays.deepToString(board) + ", turn=" + turn + "}";
    }
}
